#!/bin/bash

# The SBATCH directives must appear before any executable line in this script.

#SBATCH --qos high2         # QOS (priority).
#SBATCH -N 1               # Number of nodes requested.
#SBATCH -n 1               # Number of tasks (i.e. processes).
#SBATCH --cpus-per-task=1  # Number of cores per task.
#SBATCH --gres=gpu:1       # Number of GPUs.
#SBATCH -t 60-00:00          # Time requested (D-HH:MM).
#SBATCH --nodelist=em6    # Uncomment if you need a specific machine.

# Uncomment this to have Slurm cd to a directory before running the script.
# You can also just run the script from the directory you want to be in.
#SBATCH -D /home/code/test_time_training/ttt_mae

# Uncomment to control the output files. By default stdout and stderr go to
# the same place, but if you use both commands below they'll be split up.
# %N is the hostname (if used, will create output(s) per node).
# %j is jobid.
##SBATCH -o slurm.%N.%j.out    # STDOUT
##SBATCH -e slurm.%N.%j.err    # STDERR

# Print some info for context.
source ~/.bashrc
conda activate taming
cd /home/code/test_time_training/ttt_mae

nvidia-smi
# Python will buffer output of your script unless you set this.
# If you're not using python, figure out how to turn off output
# buffering when stdout is a file, or else when watching your output
# script you'll only get updated every several lines printed.
export PYTHONUNBUFFERED=1

OUTPUT_DIR_BASE='/home/code/test_time_training/ttt_mae/output_dir/finetuned_model/no_test_time'
RESUME_MODEL='/home/code/deep_transformer_prior/mae_orig/demo/mae_visualize_vit_large.pth'
RESUME_FINETUNE='/home/code/deep_transformer_prior/mae_orig/output_dir/mae_orig_finetune_with_decoder/checkpoint-89.pth'
# First let's run the original dataset:
DATA_PATH='/home/group/ilsvrc/val'

python test_without_adaptation.py \
        --data_path ${DATA_PATH} \
        --model mae_vit_large_patch16 \
        --input_size 224 \
        --resume_model ${RESUME_MODEL} \
        --resume_finetune ${RESUME_FINETUNE} \
        --output_dir "$OUTPUT_DIR_BASE/original/minimized_multitest_32" \
        --minimizer '/home/code/test_time_training/ttt_mae/models/perm.npy' \
        --test_ensemble_percent 0.1 \
        --test_ensemble_batch_size 32 \


DATA_PATH_BASE='/scratch/imagenet_c/imagenet_c/'
# #  
for DATASET in  'snow' 'brightness' 'fog' 'frost' 'contrast' 'glass_blur'  'motion_blur'  'shot_noise' 'defocus_blur' 'gaussian_blur' 'impulse_noise' 'pixelate' 'spatter' 'zoom_blur' 'elastic_transform' 'gaussian_noise' 'jpeg_compression' 'saturate' 'speckle_noise'
do 
        python test_without_adaptation.py \
                --data_path "$DATA_PATH_BASE/$DATASET/5" \
                --model mae_vit_large_patch16 \
                --input_size 224 \
                --resume_model ${RESUME_MODEL} \
                --resume_finetune ${RESUME_FINETUNE} \
                --output_dir "$OUTPUT_DIR_BASE/$DATASET/minimized_multitest_32" \
                --test_ensemble_batch_size 32 \
                --test_ensemble_percent 0.1 \
                --minimizer '/home/code/test_time_training/ttt_mae/models/perm.npy' 
                

done


# Print completion time.
date